<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Preview
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Twilio\Rest\Preview\Wireless;

use Twilio\Exceptions\TwilioException;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;
use Twilio\InstanceContext;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;


class RatePlanContext extends InstanceContext
    {
    /**
     * Initialize the RatePlanContext
     *
     * @param Version $version Version that contains the resource
     * @param string $sid 
     */
    public function __construct(
        Version $version,
        $sid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'sid' =>
            $sid,
        ];

        $this->uri = '/RatePlans/' . \rawurlencode($sid)
        .'';
    }

    /**
     * Helper function for Delete
     *
     * @return Response Deleted Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _delete(): Response
    {
        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded' ]);
        return $this->version->handleRequest('DELETE', $this->uri, [], [], $headers, "delete");
    }

    /**
     * Delete the RatePlanInstance
     *
     * @return bool True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete(): bool
    {
        $response = $this->_delete();
        
        return true;
    }

    /**
     * Delete the RatePlanInstance with Metadata
     *
     * @return ResourceMetadata The Deleted Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function deleteWithMetadata(): ResourceMetadata
    {
        $response = $this->_delete();
        
        return new ResourceMetadata(
            null,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Helper function for Fetch
     *
     * @return Response Fetched Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _fetch(): Response
    {
        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('GET', $this->uri, [], [], $headers, "fetch");
    }

    /**
     * Fetch the RatePlanInstance
     *
     * @return RatePlanInstance Fetched RatePlanInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): RatePlanInstance
    {
        $response = $this->_fetch();
        return new RatePlanInstance(
            $this->version,
            $response->getContent(),
            $this->solution['sid']
        );
        
    }

    /**
     * Fetch the RatePlanInstance with Metadata
     *
     * @return ResourceMetadata The Fetched Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetchWithMetadata(): ResourceMetadata
    {
        $response = $this->_fetch();
        $resource = new RatePlanInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['sid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Helper function for Update
     *
     * @param array|Options $options Optional Arguments
     * @return Response Updated Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _update(array $options = []): Response
    {
        $options = new Values($options);

        $data = Values::of([
            'UniqueName' =>
                $options['uniqueName'],
            'FriendlyName' =>
                $options['friendlyName'],
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('POST', $this->uri, [], $data, $headers, "update");
    }

    /**
     * Update the RatePlanInstance
     *
     * @param array|Options $options Optional Arguments
     * @return RatePlanInstance Updated RatePlanInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(array $options = []): RatePlanInstance
    {
        $response = $this->_update($options);
        return new RatePlanInstance(
            $this->version,
            $response->getContent(),
            $this->solution['sid']
        );
        
    }

    /**
     * Update the RatePlanInstance with Metadata
     *
     * @param array|Options $options Optional Arguments
     * @return ResourceMetadata The Updated Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function updateWithMetadata(array $options = []): ResourceMetadata
    {
        $response = $this->_update($options);
        $resource = new RatePlanInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['sid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Preview.Wireless.RatePlanContext ' . \implode(' ', $context) . ']';
    }
}
