<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Flex
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Twilio\Rest\FlexApi\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;
use Twilio\InstanceContext;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;
use Twilio\Serialize;


class InsightsQuestionnairesContext extends InstanceContext
    {
    /**
     * Initialize the InsightsQuestionnairesContext
     *
     * @param Version $version Version that contains the resource
     * @param string $questionnaireSid The SID of the questionnaire
     */
    public function __construct(
        Version $version,
        $questionnaireSid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'questionnaireSid' =>
            $questionnaireSid,
        ];

        $this->uri = '/Insights/QualityManagement/Questionnaires/' . \rawurlencode($questionnaireSid)
        .'';
    }

    /**
     * Helper function for Delete
     *
     * @param array|Options $options Optional Arguments
     * @return Response Deleted Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _delete(array $options = []): Response
    {
        $options = new Values($options);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded' , 'Authorization' => $options['authorization']]);
        return $this->version->handleRequest('DELETE', $this->uri, [], [], $headers, "delete");
    }

    /**
     * Delete the InsightsQuestionnairesInstance
     *
     * @param array|Options $options Optional Arguments
     * @return bool True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete(array $options = []): bool
    {
        $response = $this->_delete($options);
        
        return true;
    }

    /**
     * Delete the InsightsQuestionnairesInstance with Metadata
     *
     * @param array|Options $options Optional Arguments
     * @return ResourceMetadata The Deleted Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function deleteWithMetadata(array $options = []): ResourceMetadata
    {
        $response = $this->_delete($options);
        
        return new ResourceMetadata(
            null,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Helper function for Fetch
     *
     * @param array|Options $options Optional Arguments
     * @return Response Fetched Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _fetch(array $options = []): Response
    {
        $options = new Values($options);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' , 'Authorization' => $options['authorization']]);
        return $this->version->handleRequest('GET', $this->uri, [], [], $headers, "fetch");
    }

    /**
     * Fetch the InsightsQuestionnairesInstance
     *
     * @param array|Options $options Optional Arguments
     * @return InsightsQuestionnairesInstance Fetched InsightsQuestionnairesInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(array $options = []): InsightsQuestionnairesInstance
    {
        $response = $this->_fetch($options);
        return new InsightsQuestionnairesInstance(
            $this->version,
            $response->getContent(),
            $this->solution['questionnaireSid']
        );
        
    }

    /**
     * Fetch the InsightsQuestionnairesInstance with Metadata
     *
     * @param array|Options $options Optional Arguments
     * @return ResourceMetadata The Fetched Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetchWithMetadata(array $options = []): ResourceMetadata
    {
        $response = $this->_fetch($options);
        $resource = new InsightsQuestionnairesInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['questionnaireSid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Helper function for Update
     *
     * @param bool $active The flag to enable or disable questionnaire
     * @param array|Options $options Optional Arguments
     * @return Response Updated Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _update(bool $active, array $options = []): Response
    {
        $options = new Values($options);

        $data = Values::of([
            'Active' =>
                Serialize::booleanToString($active),
            'Name' =>
                $options['name'],
            'Description' =>
                $options['description'],
            'QuestionSids' =>
                Serialize::map($options['questionSids'], function ($e) { return $e; }),
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' , 'Authorization' => $options['authorization']]);
        return $this->version->handleRequest('POST', $this->uri, [], $data, $headers, "update");
    }

    /**
     * Update the InsightsQuestionnairesInstance
     *
     * @param bool $active The flag to enable or disable questionnaire
     * @param array|Options $options Optional Arguments
     * @return InsightsQuestionnairesInstance Updated InsightsQuestionnairesInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(bool $active, array $options = []): InsightsQuestionnairesInstance
    {
        $response = $this->_update( $active, $options);
        return new InsightsQuestionnairesInstance(
            $this->version,
            $response->getContent(),
            $this->solution['questionnaireSid']
        );
        
    }

    /**
     * Update the InsightsQuestionnairesInstance with Metadata
     *
     * @param bool $active The flag to enable or disable questionnaire
     * @param array|Options $options Optional Arguments
     * @return ResourceMetadata The Updated Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function updateWithMetadata(bool $active, array $options = []): ResourceMetadata
    {
        $response = $this->_update( $active, $options);
        $resource = new InsightsQuestionnairesInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['questionnaireSid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.FlexApi.V1.InsightsQuestionnairesContext ' . \implode(' ', $context) . ']';
    }
}
