<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Api
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Api\V2010\Account;

use Twilio\ListResource;
use Twilio\Stream;
use Twilio\Values;
use Twilio\Version;
use Twilio\Http\Response;
use Twilio\Metadata\ArrayMetadata;
use Twilio\Metadata\PageMetadata;
use Twilio\Metadata\StreamMetadata;


class AvailablePhoneNumberCountryList extends ListResource
    {
    /**
     * Construct the AvailablePhoneNumberCountryList
     *
     * @param Version $version Version that contains the resource
     * @param string $accountSid The SID of the [Account](https://www.twilio.com/docs/iam/api/account) requesting the available phone number Country resource.
     */
    public function __construct(
        Version $version,
        string $accountSid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'accountSid' =>
            $accountSid,
        
        ];

        $this->uri = '/Accounts/' . \rawurlencode($accountSid)
        .'/AvailablePhoneNumbers.json';
    }

    /**
     * Reads AvailablePhoneNumberCountryInstance records from the API as a list.
     * Unlike stream(), this operation is eager and will load `limit` records into
     * memory before returning.
     *
     * @param int $limit Upper limit for the number of records to return. read()
     *                   guarantees to never return more than limit.  Default is no
     *                   limit
     * @param mixed $pageSize Number of records to fetch per request, when not set
     *                        will use the default value of 50 records.  If no
     *                        page_size is defined but a limit is defined, read()
     *                        will attempt to read the limit with the most
     *                        efficient page size, i.e. min(limit, 1000)
     * @return AvailablePhoneNumberCountryInstance[] Array of results
     */
    public function read(?int $limit = null, $pageSize = null): array
    {
        return \iterator_to_array($this->stream($limit, $pageSize), false);
    }

    /**
     * Reads AvailablePhoneNumberCountryInstance records from the API as a list
     * Unlike stream(), this operation is eager and will load `limit` records into
     * memory before returning.
     *
     * @param int $limit Upper limit for the number of records to return. read()
     *                   guarantees to never return more than limit.  Default is no
     *                   limit
     * @param mixed $pageSize Number of records to fetch per request, when not set
     *                        will use the default value of 50 records.  If no
     *                        page_size is defined but a limit is defined, read()
     *                        will attempt to read the limit with the most
     *                        efficient page size, i.e. min(limit, 1000)
     * @return ArrayMetadata Array of results along with metadata
     */
    public function readWithMetadata(?int $limit = null, $pageSize = null): ArrayMetadata
    {
        $streamWithMetadata = $this->streamWithMetadata($limit, $pageSize);
        $readResponse = \iterator_to_array($streamWithMetadata, false);
        return new ArrayMetadata(
            $readResponse,
            $streamWithMetadata->getStatusCode(),
            $streamWithMetadata->getHeaders()
        );
    }

    /**
     * Streams AvailablePhoneNumberCountryInstance records from the API as a generator stream.
     * This operation lazily loads records as efficiently as possible until the
     * limit
     * is reached.
     * The results are returned as a generator, so this operation is memory
     * efficient.
     *
     * @param int $limit Upper limit for the number of records to return. stream()
     *                   guarantees to never return more than limit.  Default is no
     *                   limit
     * @param mixed $pageSize Number of records to fetch per request, when not set
     *                        will use the default value of 50 records.  If no
     *                        page_size is defined but a limit is defined, stream()
     *                        will attempt to read the limit with the most
     *                        efficient page size, i.e. min(limit, 1000)
     * @return Stream stream of results
     */
    public function stream(?int $limit = null, $pageSize = null): Stream
    {
        $limits = $this->version->readLimits($limit, $pageSize);

        $page = $this->page($limits['pageSize']);

        return $this->version->stream($page, $limits['limit'], $limits['pageLimit']);
    }

    /**
     * Streams AvailablePhoneNumberCountryInstance records from the API as a generator stream and returns result with Metadata
     * This operation lazily loads records as efficiently as possible until the
     * limit
     * is reached.
     * The results are returned as a generator, so this operation is memory
     * efficient.
     *
     * @param int $limit Upper limit for the number of records to return. stream()
     *                   guarantees to never return more than limit.  Default is no
     *                   limit
     * @param mixed $pageSize Number of records to fetch per request, when not set
     *                        will use the default value of 50 records.  If no
     *                        page_size is defined but a limit is defined, stream()
     *                        will attempt to read the limit with the most
     *                        efficient page size, i.e. min(limit, 1000)
     * @return StreamMetadata stream of results with metadata
     */
    public function streamWithMetadata(?int $limit = null, $pageSize = null): StreamMetadata
    {
        $limits = $this->version->readLimits($limit, $pageSize);

        $pageWithMetadata = $this->pageWithMetadata($limits['pageSize']);

        $stream = $this->version->stream($pageWithMetadata->getPage(), $limits['limit'], $limits['pageLimit']);

        return new StreamMetadata(
            $stream,
            $pageWithMetadata->getStatusCode(),
            $pageWithMetadata->getHeaders()
        );
    }

    /**
     * Helper function for Page
     *
     * @param mixed $pageSize Number of records to return, defaults to 50
     * @param string $pageToken PageToken provided by the API
     * @param mixed $pageNumber Page Number, this value is simply for client state
     * @return Response Paged Response
     */
    private function _page(
        $pageSize = Values::NONE,
        string $pageToken = Values::NONE,
        $pageNumber = Values::NONE
    ): Response
    {

        $params = Values::of([
            'PageToken' => $pageToken,
            'Page' => $pageNumber,
            'PageSize' => $pageSize,
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json']);
        return $this->version->page('GET', $this->uri, $params, [], $headers);
    }

    /**
     * Retrieve a single page of AvailablePhoneNumberCountryInstance records from the API.
     * Request is executed immediately
     *
     * @param mixed $pageSize Number of records to return, defaults to 50
     * @param string $pageToken PageToken provided by the API
     * @param mixed $pageNumber Page Number, this value is simply for client state
     * @return AvailablePhoneNumberCountryPage Page of AvailablePhoneNumberCountryInstance
     */
    public function page(
        $pageSize = Values::NONE,
        string $pageToken = Values::NONE,
        $pageNumber = Values::NONE
    ): AvailablePhoneNumberCountryPage
    {
        $response = $this->_page( $pageSize, $pageToken, $pageNumber);

        return new AvailablePhoneNumberCountryPage($this->version, $response, $this->solution);
    }

    /**
     * Retrieve a single page of AvailablePhoneNumberCountryInstance records with metadata
     * Request is executed immediately
     *
     * @param mixed $pageSize Number of records to return, defaults to 50
     * @param string $pageToken PageToken provided by the API
     * @param mixed $pageNumber Page Number, this value is simply for client state
     * @return PageMetadata of AvailablePhoneNumberCountryInstance
     */
    public function pageWithMetadata(
        $pageSize = Values::NONE,
        string $pageToken = Values::NONE,
        $pageNumber = Values::NONE
    ): PageMetadata
    {
        $response = $this->_page( $pageSize, $pageToken, $pageNumber);

        $resource =  new AvailablePhoneNumberCountryPage($this->version, $response, $this->solution);

        return new PageMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }

    /**
     * Retrieve a specific page of AvailablePhoneNumberCountryInstance records from the API.
     * Request is executed immediately
     *
     * @param string $targetUrl API-generated URL for the requested results page
     * @return AvailablePhoneNumberCountryPage Page of AvailablePhoneNumberCountryInstance
     */
    public function getPage(string $targetUrl): AvailablePhoneNumberCountryPage
    {
        $response = $this->version->getDomain()->getClient()->request(
            'GET',
            $targetUrl
        );

        return new AvailablePhoneNumberCountryPage($this->version, $response, $this->solution);
    }


    /**
     * Constructs a AvailablePhoneNumberCountryContext
     *
     * @param string $countryCode The [ISO-3166-1](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code of the country to fetch available phone number information about.
     */
    public function getContext(
        string $countryCode
        
    ): AvailablePhoneNumberCountryContext
    {
        return new AvailablePhoneNumberCountryContext(
            $this->version,
            $this->solution['accountSid'],
            $countryCode
        );
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Api.V2010.AvailablePhoneNumberCountryList]';
    }
}
