<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>PHP Test Page</h2>";
echo "PHP Version: " . phpversion() . "<br>";
echo "Current Directory: " . __DIR__ . "<br>";

// Test database connection
try {
    $pdo = new PDO(
        'mysql:host=localhost;port=3306;dbname=wdaylk_stock_management_system',
        'wdaylk_nethmavilhandesilva',
        'nethma1234567'
    );
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    echo "✅ Database connection: SUCCESSFUL<br>";
} catch(PDOException $e) {
    echo "❌ Database connection: FAILED - " . $e->getMessage() . "<br>";
}

// Check if Laravel files exist
if (file_exists(__DIR__ . '/application/vendor/autoload.php')) {
    echo "✅ Vendor autoload: FOUND<br>";
} else {
    echo "❌ Vendor autoload: NOT FOUND<br>";
}

if (file_exists(__DIR__ . '/application/bootstrap/app.php')) {
    echo "✅ Bootstrap app.php: FOUND<br>";
} else {
    echo "❌ Bootstrap app.php: NOT FOUND<br>";
}

// Check storage permissions
$storagePath = __DIR__ . '/application/storage';
if (is_writable($storagePath)) {
    echo "✅ Storage folder: WRITABLE<br>";
} else {
    echo "❌ Storage folder: NOT WRITABLE (needs permissions 755 or 775)<br>";
}

phpinfo();
?>