<?php
// Force PHP memory limit for heavy Laravel bootstrap
ini_set('memory_limit', '512M');

// Display all errors for debugging (you can disable after live)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

use Illuminate\Foundation\Application;
use Illuminate\Http\Request;

define('LARAVEL_START', microtime(true));

// Maintenance mode check
if (file_exists($maintenance = __DIR__ . '/application/storage/framework/maintenance.php')) {
    require $maintenance;
}

// Autoload Composer packages
require __DIR__ . '/application/vendor/autoload.php';

// Bootstrap Laravel
/** @var Application $app */
$app = require_once __DIR__ . '/application/bootstrap/app.php';

// Handle the HTTP request
$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
$response = $kernel->handle(
    $request = Request::capture()
);

$response->send();
$kernel->terminate($request, $response);