<?php

echo "<h2>Laravel Deployment Check</h2><pre>";

$basePath = __DIR__ . '/application';

$requiredFiles = [
    'artisan',
    'composer.json',
    '.env',
    'vendor/autoload.php',
    'bootstrap/app.php',
    'routes/web.php',
];

$requiredFolders = [
    'app',
    'bootstrap',
    'config',
    'database',
    'public',
    'resources',
    'routes',
    'storage',
    'vendor',
];

// Check index.php in public_html
if (file_exists(__DIR__ . '/index.php')) {
    echo "✅ EXISTS: public_html/index.php\n";
} else {
    echo "❌ MISSING: public_html/index.php\n";
}

// Check .htaccess in public_html
if (file_exists(__DIR__ . '/.htaccess')) {
    echo "✅ EXISTS: public_html/.htaccess\n";
} else {
    echo "❌ MISSING: public_html/.htaccess\n";
}

echo "\n--- Checking application files ---\n";

foreach ($requiredFiles as $file) {
    if (file_exists($basePath . '/' . $file)) {
        echo "✅ EXISTS: application/$file\n";
    } else {
        echo "❌ MISSING: application/$file\n";
    }
}

echo "\n--- Checking application folders ---\n";

foreach ($requiredFolders as $folder) {
    if (is_dir($basePath . '/' . $folder)) {
        echo "✅ EXISTS: application/$folder\n";
    } else {
        echo "❌ MISSING: application/$folder\n";
    }
}

echo "\n--- Checking Storage Permissions ---\n";

if (is_writable($basePath . '/storage')) {
    echo "✅ storage folder is writable\n";
} else {
    echo "❌ storage folder is NOT writable\n";
}

if (is_writable($basePath . '/bootstrap/cache')) {
    echo "✅ bootstrap/cache is writable\n";
} else {
    echo "❌ bootstrap/cache is NOT writable\n";
}

echo "</pre>";