<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Messaging
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Messaging\V2;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Values;
use Twilio\Version;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;


class TypingIndicatorList extends ListResource
    {
    /**
     * Construct the TypingIndicatorList
     *
     * @param Version $version Version that contains the resource
     */
    public function __construct(
        Version $version
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        ];

        $this->uri = '/Indicators/Typing.json';
    }

    /**
     * Helper function for Create
     *
     * @param string $channel Shared channel identifier
     * @param string $messageId Message SID that identifies the conversation thread for the typing indicator. Must be a valid Twilio Message SID (SM*) or Media SID (MM*) from an existing WhatsApp conversation.
     * @return Response Created Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _create(string $channel, string $messageId): Response
    {
        $data = Values::of([
            'channel' =>
                $channel,
            'messageId' =>
                $messageId,
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('POST', $this->uri, [], $data, $headers, "create");
    }

    /**
     * Create the TypingIndicatorInstance
     *
     * @param string $channel Shared channel identifier
     * @param string $messageId Message SID that identifies the conversation thread for the typing indicator. Must be a valid Twilio Message SID (SM*) or Media SID (MM*) from an existing WhatsApp conversation.
     * @return TypingIndicatorInstance Created TypingIndicatorInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create(string $channel, string $messageId): TypingIndicatorInstance
    {
        $response = $this->_create( $channel,  $messageId);
        return new TypingIndicatorInstance(
            $this->version,
            $response->getContent()
        );
        
    }

    /**
     * Create the TypingIndicatorInstance with Metadata
     *
     * @param string $channel Shared channel identifier
     * @param string $messageId Message SID that identifies the conversation thread for the typing indicator. Must be a valid Twilio Message SID (SM*) or Media SID (MM*) from an existing WhatsApp conversation.
     * @return ResourceMetadata The Created Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function createWithMetadata(string $channel, string $messageId): ResourceMetadata
    {
        $response = $this->_create( $channel,  $messageId);
        $resource = new TypingIndicatorInstance(
                        $this->version,
                        $response->getContent()
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Messaging.V2.TypingIndicatorList]';
    }
}
