<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Marketplace
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Marketplace\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;


class ModuleDataList extends ListResource
    {
    /**
     * Construct the ModuleDataList
     *
     * @param Version $version Version that contains the resource
     */
    public function __construct(
        Version $version
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        ];

        $this->uri = '/Listings';
    }

    /**
     * Helper function for Create
     *
     * @param array|Options $options Optional Arguments
     * @return Response Created Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _create(array $options = []): Response
    {
        $options = new Values($options);

        $data = Values::of([
            'ModuleInfo' =>
                $options['moduleInfo'],
            'Configuration' =>
                $options['configuration'],
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('POST', $this->uri, [], $data, $headers, "create");
    }

    /**
     * Create the ModuleDataInstance
     *
     * @param array|Options $options Optional Arguments
     * @return ModuleDataInstance Created ModuleDataInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create(array $options = []): ModuleDataInstance
    {
        $response = $this->_create($options);
        return new ModuleDataInstance(
            $this->version,
            $response->getContent()
        );
        
    }

    /**
     * Create the ModuleDataInstance with Metadata
     *
     * @param array|Options $options Optional Arguments
     * @return ResourceMetadata The Created Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function createWithMetadata(array $options = []): ResourceMetadata
    {
        $response = $this->_create($options);
        $resource = new ModuleDataInstance(
                        $this->version,
                        $response->getContent()
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Helper function for Fetch
     *
     * @return Response Fetched Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _fetch(): Response
    {
        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('GET', $this->uri, [], [], $headers, "fetch");
    }

    /**
     * Fetch the ModuleDataInstance
     *
     * @return ModuleDataInstance Fetched ModuleDataInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): ModuleDataInstance
    {
        $response = $this->_fetch();
        return new ModuleDataInstance(
            $this->version,
            $response->getContent()
        );
        
    }

    /**
     * Fetch the ModuleDataInstance with Metadata
     *
     * @return ResourceMetadata The Fetched Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetchWithMetadata(): ResourceMetadata
    {
        $response = $this->_fetch();
        $resource = new ModuleDataInstance(
                        $this->version,
                        $response->getContent()
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Marketplace.V1.ModuleDataList]';
    }
}
