<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Iam
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Iam\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Values;
use Twilio\Version;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;


class OAuthAppList extends ListResource
    {
    /**
     * Construct the OAuthAppList
     *
     * @param Version $version Version that contains the resource
     */
    public function __construct(
        Version $version
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        ];

        $this->uri = '/Account/OAuthApps';
    }

    /**
     * Helper function for Create
     *
     * @param IamV1AccountVendorOauthAppCreateRequest $iamV1AccountVendorOauthAppCreateRequest
     * @return Response Created Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _create(IamV1AccountVendorOauthAppCreateRequest $iamV1AccountVendorOauthAppCreateRequest): Response
    {
        $headers = Values::of(['Content-Type' => 'application/json', 'Accept' => 'application/json' ]);
        $data = $iamV1AccountVendorOauthAppCreateRequest->toArray();
        return $this->version->handleRequest('POST', $this->uri, [], $data, $headers, "create");
    }

    /**
     * Create the OAuthAppInstance
     *
     * @param IamV1AccountVendorOauthAppCreateRequest $iamV1AccountVendorOauthAppCreateRequest
     * @return OAuthAppInstance Created OAuthAppInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create(IamV1AccountVendorOauthAppCreateRequest $iamV1AccountVendorOauthAppCreateRequest): OAuthAppInstance
    {
        $response = $this->_create( $iamV1AccountVendorOauthAppCreateRequest);
        return new OAuthAppInstance(
            $this->version,
            $response->getContent()
        );
        
    }

    /**
     * Create the OAuthAppInstance with Metadata
     *
     * @param IamV1AccountVendorOauthAppCreateRequest $iamV1AccountVendorOauthAppCreateRequest
     * @return ResourceMetadata The Created Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function createWithMetadata(IamV1AccountVendorOauthAppCreateRequest $iamV1AccountVendorOauthAppCreateRequest): ResourceMetadata
    {
        $response = $this->_create( $iamV1AccountVendorOauthAppCreateRequest);
        $resource = new OAuthAppInstance(
                        $this->version,
                        $response->getContent()
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Constructs a OAuthAppContext
     *
     * @param string $sid Unique ID (sid) of the OAuth app
     */
    public function getContext(
        string $sid
        
    ): OAuthAppContext
    {
        return new OAuthAppContext(
            $this->version,
            $sid
        );
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Iam.V1.OAuthAppList]';
    }
}
