<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Mail\Mailables\Address;
use Illuminate\Queue\SerializesModels;

class DayEndWeightReportMail extends Mailable
{
    use Queueable, SerializesModels;

    public $reportData;

    /**
     * Create a new message instance.
     */
    public function __construct(array $reportData)
    {
        $this->reportData = $reportData;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            to: [
                new Address('nethmavilhan@gmail.com'),
                new Address('thrcorner@gmail.com') // Added second email recipient
            ],
            subject: 'Daily Sales Process and Weight Report - ' . ($this->reportData['processLogDate'] ?? now()->toDateString()),
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            markdown: 'emails.day-end-report',
            with: [
                'reportData' => $this->reportData
            ]
        );
    }

    public function attachments(): array
    {
        return [];
    }
}
